/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class IncrementalModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<IncrementalModifierRecipeBuilder> {
    private Ingredient input = Ingredient.f_43901_;
    private int amountPerItem;
    private int neededPerLevel;
    private ItemStack leftover = ItemStack.f_41583_;

    protected IncrementalModifierRecipeBuilder(ModifierEntry result) {
        super(result);
    }

    public static IncrementalModifierRecipeBuilder modifier(ModifierEntry modifier) {
        return new IncrementalModifierRecipeBuilder(modifier);
    }

    public static IncrementalModifierRecipeBuilder modifier(ModifierId modifier) {
        return IncrementalModifierRecipeBuilder.modifier(new ModifierEntry(modifier, 1));
    }

    public static IncrementalModifierRecipeBuilder modifier(LazyModifier modifier) {
        return IncrementalModifierRecipeBuilder.modifier(modifier.getId());
    }

    public IncrementalModifierRecipeBuilder setInput(Ingredient input, int amountPerItem, int neededPerLevel) {
        if (amountPerItem < 1) {
            throw new IllegalArgumentException("Amount per item must be at least 1");
        }
        if (neededPerLevel <= amountPerItem) {
            throw new IllegalArgumentException("Needed per level must be greater than amount per item");
        }
        this.input = input;
        this.amountPerItem = amountPerItem;
        this.neededPerLevel = neededPerLevel;
        return this;
    }

    public IncrementalModifierRecipeBuilder setInput(ItemLike item, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), amountPerItem, neededPerLevel);
    }

    public IncrementalModifierRecipeBuilder setInput(TagKey<Item> tag, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.m_204132_(tag), amountPerItem, neededPerLevel);
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.input == Ingredient.f_43901_) {
            throw new IllegalStateException("Must set input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new FinishedAdding(id, advancementId, false));
        if (this.includeUnarmed) {
            if (this.requirements != ModifierMatch.ALWAYS) {
                throw new IllegalStateException("Cannot use includeUnarmed with requirements");
            }
            consumer.accept((FinishedRecipe)new FinishedAdding(new ResourceLocation(id.m_135827_(), id.m_135815_() + "_unarmed"), null, true));
        }
    }

    @Override
    public IncrementalModifierRecipeBuilder saveSalvage(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.salvageMaxLevel != 0 && this.salvageMaxLevel < this.salvageMinLevel) {
            throw new IllegalStateException("Max level must be greater than min level");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractModifierRecipeBuilder.SalvageFinishedRecipe(this, id, advancementId));
        return this;
    }

    public static JsonElement serializeResult(ItemStack result) {
        String itemName = Objects.requireNonNull(result.m_41720_().getRegistryName()).toString();
        if (result.m_41782_()) {
            JsonObject jsonResult = new JsonObject();
            jsonResult.addProperty("item", itemName);
            int count = result.m_41613_();
            if (count > 1) {
                jsonResult.addProperty("count", (Number)count);
            }
            jsonResult.addProperty("nbt", Objects.requireNonNull(result.m_41783_()).toString());
            return jsonResult;
        }
        return new JsonPrimitive(itemName);
    }

    public IncrementalModifierRecipeBuilder setLeftover(ItemStack leftover) {
        this.leftover = leftover;
        return this;
    }

    private class FinishedAdding
    extends AbstractModifierRecipeBuilder.ModifierFinishedRecipe {
        public FinishedAdding(@Nullable ResourceLocation ID, ResourceLocation advancementID, boolean withUnarmed) {
            super(IncrementalModifierRecipeBuilder.this, ID, advancementID, withUnarmed);
        }

        @Override
        public void m_7917_(JsonObject json) {
            json.add("input", IncrementalModifierRecipeBuilder.this.input.m_43942_());
            json.addProperty("amount_per_item", (Number)IncrementalModifierRecipeBuilder.this.amountPerItem);
            json.addProperty("needed_per_level", (Number)IncrementalModifierRecipeBuilder.this.neededPerLevel);
            if (IncrementalModifierRecipeBuilder.this.leftover != ItemStack.f_41583_) {
                json.add("leftover", IncrementalModifierRecipeBuilder.serializeResult(IncrementalModifierRecipeBuilder.this.leftover));
            }
            super.m_7917_(json);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TinkerModifiers.incrementalModifierSerializer.get();
        }
    }
}

